#!/usr/bin/env python3
import json
import math

rename = {
    "SIMPLE": "SIMPLE~\\cite{2022_wolsing_simple}",
    "Seq2SeqNN": "Seq2SeqNN~\\cite{2020_kim_seq2seq}",
    "Invariant": "Invariant",
    "GeCo": "GeCo",
    "PASAD": "PASAD",
    "MinMax": "MinMax",
    "Gradient": "Gradient",
    "Steadytime": "Steadytime",
    "Histogram": "Histogram",
    "PASAD": "PASAD",
}

for ids in ["MinMax", "Gradient", "Steadytime", "Histogram", "SIMPLE", "Seq2SeqNN", "GeCo", "Invariant", "PASAD"]:

    with open(f"./outputs/{ids}.json", "r") as f:
        ergs = json.load(f)

    numattacks = ergs["attacks"]
    det = ergs["detected-attacks"]
    fpa = ergs["false-alarms"]
    fpafiltered = ergs["alarm-during-maintenance"]
    ttd = f"{ergs["average-ttd"]:.2f}s" if not math.isnan(ergs["average-ttd"]) else "--"
    print(f"\t{rename[ids]} & {det}/{numattacks} & {fpa}({fpafiltered}) & {ttd} \\tabularnewline \\midrule")

